package mole.entities.obstacles 
{
	import mole.CSoundAssets;
	import mole.CSoundManager;
	import mole.entities.particles.CParticleEmitter;
	import mole.Main;
	import net.flashpunk.graphics.Image;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Spritemap;
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CObstacle extends Entity
	{
		/**
		 * 
		 * @param	_Asset
		 * @param	_nDifficulty
		 */
		public function CObstacle(_nPosX:int, _Asset:Class, _nDifficulty:int) 
		{
			m_Type = _Asset;
			if (_Asset == CObstaclesAssets.SOL_2_PNG)
			{
				var spriteMap:Spritemap = new Spritemap(_Asset, 64, 64);
				spriteMap.add("idle", [0, 1, 2, 3, 4], 30, true);
				graphic = spriteMap;
				width = height = 64;
				spriteMap.play("idle");
			}
			else
			{
				var image:Image = new Image(_Asset);
				width = image.width;
				height = image.height;
				graphic = image;
			}
			
			m_nDifficulty = _nDifficulty;
			layer = 10;
			m_nPosX = _nPosX;
			
			type = "obstacle";
		}
		
		override public function update():void
		{
			if (collide("perforator", x, y))
			{
				Explode();
			}
		}
		
		public function Explode():void
		{
			if(CParticleEmitter.RangeRandom(0, 100) > 75)
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.DESTROY]);
				
			Main.World.remove(this);
			
			if(y < 256)
				CParticleEmitter.GenerateParticlesAtPoint(x - (width / 2), y - (height / 2), 0, 1, 2, 32, -1.0, 0, -0.5, 0.5, 250, 280, 0);
			else if(height == 32)
				CParticleEmitter.GenerateParticlesAtPoint(x - (width / 2), y - (height * 2), 0, 1, 2, 32, -1.0, -0.2, -0.8, -0.1, 250, 280, 0);
			else
				CParticleEmitter.GenerateParticlesAtPoint(x - (width / 2), y - height, 0, 1, 2, 32, -1.0, -0.2, -0.8, -0.1, 250, 280, 0);
		}
		public function GetPosX():int { return m_nPosX;}
		
		public function get difficulty():int { return m_nDifficulty; }
		
		public function GetId():Class { return m_Type;}
		
		private var m_nDifficulty:int; 
		private var m_nPosX:int;
		private var m_Type:Class;
	}

}